/**
* \file: device.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AMM_MODEL_DEVICE_H
#define AMM_MODEL_DEVICE_H

#include "automounter_types.h"

// forward declarations of the data structures that hold the model data. The definition of the data structure is hidden.
// It can be found in the respective C files. Properties can be accessed via respective set and get functions
typedef struct partition_t partition_t;
typedef struct device_metadata_t device_metadata_t;
typedef struct device_t device_t;

// declaration of a call back function which can be used to observe state changes of the device. It is used while
// processing a umount request to detect when it is done.
typedef void (*device_state_change_callback_t)(device_t *device, device_state_t previous_state,
        void *data);

//getter for partition attributes
const char* device_get_id(device_t *device);

const char *device_get_device_type(device_t *device);

const char *device_get_device_identifier(device_t *device);

const char *device_get_handler_id(device_t *device);

device_state_t device_get_state(device_t *device);

const char* device_get_state_str(device_state_t state);

int device_get_detected_partition_cnt(device_t *device);

int device_get_expected_partition_cnt(device_t *device);

int device_get_working_partitions_cnt(device_t *device);

int device_get_mounted_partitions_cnt(device_t *device);

//getter to get a reference to metadata of the device. Respective get functions defined in device_metadata.h
//can be used to read out the individual attributes
device_metadata_t* device_get_metadata(device_t *device);

// set or remove a state change monitor
void device_set_state_change_monitor(device_t *device,
                    device_state_change_callback_t callback_func, void *callback_data);

void device_remove_state_change_monitor(device_t *device);

// set functions to change the device state in the model. A registered state change callback is called out of these
// functions.
void device_set_state_automounting(device_t *device, int expected_partition_cnt);

void device_set_state_automounted(device_t *device);

void device_set_state_unmounting(device_t *device);

void device_set_state_unmounted(device_t *device);

void device_set_state_invalid(device_t *device);

void device_set_state_nomedia(device_t *device);

#endif
